﻿var serverStats = {
    context: $(".v-serverStatistics"),
    datatable: null,
    initializeDataTable: function (folder) {
        this.datatable = $(".h-serverStatistics-table", this.context).a4datatable({
            advancedFilter: false,
            height: "full",
            ajaxAction: a4.getProjectAction("GetServerStatistics", "Diagnostics"),
            columns: [
                { "Title": resources.ServerName, "Data": "Name" },
                { "Title": resources.AvgResponseTime, "Data": "AvgResponseTime", "Type": "numeric" },
                { "Title": resources.MaxResponseTime, "Data": "MaxResponseTime", "Type": "numeric" },
                { "Title": resources.MaxConcurrentConnections, "Data": "MaxConcurrentConnections", "Type": "numeric" },
                { "Title": resources.RequestCount, "Data": "RequestCount", "Type": "numeric" },
                { "Title": resources.ConnectionCount, "Data": "ConnectionCount", "Type": "numeric" },
                { "Title": resources.AbnormalDisconnectionCount, "Data": "AbnormalDisconnectionCount", "Type": "numeric" },
                { "Title": resources.RejectedConnectionCount, "Data": "RejectedConnectionCount", "Type": "numeric" },
                { "Title": resources.ErrorCount, "Data": "ErrorCount", "Type": "numeric" }
            ],
            stateKey: "ServerStats",
            localizableTexts: { "All": resources.AllStatistics, "Search": resources.SearchStatistics },
            quickFilter: {
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            }
        });
    }
}

$(document).ready(function () {
    if (serverStats.context.length > 0) {
        serverStats.initializeDataTable();
    }
});